/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.CallbackErrorHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class DefaultCallbackErrorHandler
implements CallbackErrorHandler {
    private ServerInvoker serverInvoker = null;
    private ServerInvokerCallbackHandler callbackHandler = null;
    private int numOfErrorsAllowed = 5;
    private int currentNumberOfErrors = 0;
    private String handlerSubsystem = null;
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$callback$DefaultCallbackErrorHandler == null ? (class$org$jboss$remoting$callback$DefaultCallbackErrorHandler = DefaultCallbackErrorHandler.class$("org.jboss.remoting.callback.DefaultCallbackErrorHandler")) : class$org$jboss$remoting$callback$DefaultCallbackErrorHandler));
    public static final String CALLBACK_ERRORS_ALLOWED = "callbackErrorsAllowed";
    static /* synthetic */ Class class$org$jboss$remoting$callback$DefaultCallbackErrorHandler;

    public void setConfig(Map errorHandlerConfig) {
        Object value;
        this.handlerSubsystem = (String)errorHandlerConfig.get("handlerSubsystem");
        if (errorHandlerConfig != null && (value = errorHandlerConfig.get(CALLBACK_ERRORS_ALLOWED)) != null) {
            if (value instanceof String) {
                String stringValue = (String)value;
                try {
                    this.numOfErrorsAllowed = Integer.parseInt(stringValue);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Could not convert configuration value for callbackErrorsAllowed (" + stringValue + ") into a numeric value."));
                }
            } else if (value instanceof Integer) {
                this.numOfErrorsAllowed = (Integer)value;
            } else {
                log.warn((Object)("Could not convert configuration value for callbackErrorsAllowed (" + value + ") into a numeric value.  " + "Type of value should be either String or Integer."));
            }
        }
    }

    public void handleError(Throwable ex) throws Throwable {
        ++this.currentNumberOfErrors;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caught " + ex + " exception performing callback.  Number of errors sending callbacks is " + this.currentNumberOfErrors));
        }
        if (this.currentNumberOfErrors >= this.numOfErrorsAllowed) {
            log.warn((Object)"Reached max number of callback errors allowed.  Will clean up callback hander now.");
            if (this.serverInvoker != null) {
                this.serverInvoker.removeCallbackListener(this.handlerSubsystem, this.callbackHandler);
                this.callbackHandler.destroy();
            }
        } else {
            throw ex;
        }
    }

    public void setServerInvoker(ServerInvoker owner) {
        this.serverInvoker = owner;
    }

    public void setCallbackHandler(ServerInvokerCallbackHandler serverInvokerCallbackHandler) {
        this.callbackHandler = serverInvokerCallbackHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

