/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefaultLog4JLogger
implements Log,
Serializable {
    private static final String FQCN = (class$org$apache$commons$logging$impl$DefaultLog4JLogger == null ? (class$org$apache$commons$logging$impl$DefaultLog4JLogger = DefaultLog4JLogger.class$("org.apache.commons.logging.impl.DefaultLog4JLogger")) : class$org$apache$commons$logging$impl$DefaultLog4JLogger).getName();
    private static final boolean is12 = (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = DefaultLog4JLogger.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = DefaultLog4JLogger.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level);
    private Level TRACE;
    private transient Logger logger = null;
    private String name = null;
    static /* synthetic */ Class class$org$apache$commons$logging$impl$DefaultLog4JLogger;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$java$lang$String;

    private synchronized Level getTrace() {
        if (this.TRACE == null) {
            this.TRACE = Level.DEBUG;
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try {
                        Class<?> c = loader.loadClass("org.jboss.logging.XLevel");
                        Class[] sig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultLog4JLogger.class$("java.lang.String")) : class$java$lang$String, class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = DefaultLog4JLogger.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level};
                        Method toLevel = c.getMethod("toLevel", sig);
                        Object[] args = new Object[]{"TRACE", Level.DEBUG};
                        DefaultLog4JLogger.this.TRACE = (Level)toLevel.invoke(null, args);
                    }
                    catch (ClassNotFoundException ignore) {
                        System.err.println("org.jboss.logging.XLevel not found, trace maps to Level.DEBUG");
                    }
                    catch (Throwable t) {
                        if (loader instanceof URLClassLoader) {
                            URLClassLoader ucl = (URLClassLoader)loader;
                            URL[] cp = ucl.getURLs();
                            System.out.println("+++ Loader.getURLs: " + Arrays.asList(cp));
                        }
                        t.printStackTrace();
                    }
                    return null;
                }
            };
            AccessController.doPrivileged(action);
        }
        return this.TRACE;
    }

    public DefaultLog4JLogger() {
    }

    public DefaultLog4JLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
        this.TRACE = this.getTrace();
    }

    public DefaultLog4JLogger(Logger logger) {
        this.name = logger.getName();
        this.logger = logger;
    }

    public void trace(Object message) {
        Level trace = this.getTrace();
        if (is12) {
            this.getLogger().log(FQCN, (Priority)trace, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)trace, message, null);
        }
    }

    public void trace(Object message, Throwable t) {
        Level trace = this.getTrace();
        if (is12) {
            this.getLogger().log(FQCN, (Priority)trace, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)trace, message, t);
        }
    }

    public void debug(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        }
    }

    public void info(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        }
    }

    public void warn(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        }
    }

    public void error(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        }
    }

    public void fatal(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.ERROR);
        }
        return this.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.FATAL);
        }
        return this.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        Level trace = this.getTrace();
        return this.getLogger().isEnabledFor((Priority)trace);
    }

    public boolean isWarnEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.WARN);
        }
        return this.getLogger().isEnabledFor((Priority)Level.WARN);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

