/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class DefaultServiceManager
implements ServiceManager {
    private final HashMap m_objects = new HashMap();
    private final ServiceManager m_parent;
    private boolean m_readOnly;

    public DefaultServiceManager() {
        this(null);
    }

    public DefaultServiceManager(ServiceManager parent) {
        this.m_parent = parent;
    }

    public Object lookup(String role) throws ServiceException {
        Object object = this.m_objects.get(role);
        if (null != object) {
            return object;
        }
        if (null != this.m_parent) {
            return this.m_parent.lookup(role);
        }
        throw new ServiceException(role, "Unable to provide implementation for " + role, null);
    }

    public boolean hasService(String role) {
        boolean objectExists = false;
        try {
            this.lookup(role);
            objectExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectExists;
    }

    public void put(String role, Object object) {
        this.checkWriteable();
        this.m_objects.put(role, object);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator objects = this.m_objects.keySet().iterator();
        buffer.append("Services:");
        while (objects.hasNext()) {
            buffer.append("[");
            buffer.append(objects.next());
            buffer.append("]");
        }
        return buffer.toString();
    }

    protected final ServiceManager getParent() {
        return this.m_parent;
    }

    protected final Map getObjectMap() {
        return this.m_objects;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ServiceManager is read only and can not be modified");
        }
    }

    public void release(Object object) {
    }
}

