/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.soap;

import org.jboss.axis.client.Call;
import org.jboss.webservice.client.CallImpl;

import java.net.MalformedURLException;

/**
 * A factory for creating SOAPConnection objects. Implementation of this class
 * is optional. If SOAPConnectionFactory.newInstance() throws an
 * UnsupportedOperationException then the implementation does not support the
 * SAAJ communication infrastructure. Otherwise SOAPConnection objects can be
 * created by calling createConnection() on the newly created
 * SOAPConnectionFactory object.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class SOAPConnectionImpl extends org.jboss.axis.soap.SOAPConnectionImpl
{

   protected Call createCall(Object endpoint) throws MalformedURLException
   {
      return new CallImpl(endpoint);
   }
}
