/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.server;

// $Id:InvokerProviderSimple.java,v 1.0, 2005-06-24 19:07:13Z, Robert Worsnop$

import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.providers.java.RPCProvider;

import javax.xml.rpc.holders.IntHolder;
import java.lang.reflect.Method;

/**
 * A very simple reflection provider that invokes the method on the object
 * that is given in the constructor of this provider.
 *
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 */
public class InvokerProviderSimple extends RPCProvider
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 6368971333868010325L;
   private Object targetService;

   /** Creates new InvokerProviderSimple
    */
   public InvokerProviderSimple(Object targetService)
   {
      this.targetService = targetService;
   }

   /**
    * This method encapsulates the method invocation.
    *
    * @param msgContext MessageContext
    * @param method     the target method.
    * @param obj        the target object
    * @param argValues  the method arguments
    */
   protected java.lang.Object invokeMethod(MessageContext msgContext, Method method, java.lang.Object obj, java.lang.Object[] argValues) throws Exception
   {
      return method.invoke(obj, argValues);
   }

   /**
    * Get the service object whose method actually provides the service.
    * May look up in session table.
    */
   public java.lang.Object getServiceObject(MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception
   {
      return targetService;
   }

   /**
    * Return the class name of the service
    */
   protected String getServiceClassName(Handler service)
   {
      return targetService.getClass().getName();
   }
}
