/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:InvokerProviderJMX.java,v 1.0, 2005-06-24 19:07:13Z, Robert Worsnop$
package org.jboss.webservice.server;

// $Id:InvokerProviderJMX.java,v 1.0, 2005-06-24 19:07:13Z, Robert Worsnop$

import org.jboss.axis.MessageContext;
import org.jboss.logging.Logger;

import java.lang.reflect.Method;

/**
 * An Axis RPC provider for JMX endpoints.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 30-Sep-2004
 */
public class InvokerProviderJMX extends InvokerProviderJSE
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 7507097707486824402L;
   // provide logging
   private Logger log = Logger.getLogger(InvokerProviderJMX.class);

   /**
    * This method encapsulates the method invocation.
    *
    * @param msgContext MessageContext
    * @param method     the target method.
    * @param obj        the target object
    * @param argValues  the method arguments
    */
   protected Object invokeServiceEndpoint(MessageContext msgContext, Method method, Object obj, Object[] argValues)
           throws Exception
   {
      log.debug("Invoke JMX: " + method);

      // invoke the bean method
      Object retObj = null;
      return retObj;
   }
}
