/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:WebservicesMetaData.java,v 1.0, 2005-06-24 19:19:12Z, Robert Worsnop$
package org.jboss.webservice.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.net.URLClassLoader;

// $Id:WebservicesMetaData.java,v 1.0, 2005-06-24 19:19:12Z, Robert Worsnop$

/**
 * XML Binding root element for <code>webservices.xml</code>
 *
 * @author Thomas.Diesler@jboss.org
 * @since 15-April-2004
 */
public class WebservicesMetaData
{
   // The required <webservice-description> elements
   private ArrayList webserviceDescriptions = new ArrayList();

   // The modules resource class loader
   private URLClassLoader resourceCL;

   // Maps the wsdl-file to the wsdl Document
   // Note the same wsdl can be used in multiple webservice descriptions
   HashMap wsdlFileMap = new HashMap();
   // Maps the jaxrpc-mapping-file to {@link JavaWsdlMapping} object
   // Note the same jaxrpc-mapping.xml can be used in multiple webservice descriptions
   HashMap jaxrpcMappingFileMap = new HashMap();

   /**
    * Construct webservices meta data, with a given resource class loader.
    */
   public WebservicesMetaData(URLClassLoader resourceCL)
   {
      this.resourceCL = resourceCL;
   }

   public URLClassLoader getResourceLoader()
   {
      return resourceCL;
   }

   public void addWebserviceDescription(WebserviceDescriptionMetaData webserviceDescription)
   {
      webserviceDescriptions.add(webserviceDescription);
   }

   public WebserviceDescriptionMetaData[] getWebserviceDescriptions()
   {
      WebserviceDescriptionMetaData[] array = new WebserviceDescriptionMetaData[webserviceDescriptions.size()];
      webserviceDescriptions.toArray(array);
      return array;
   }
}
