/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.encoding.ser;

// $Id:MetaDataBeanSerializerFactory.java,v 1.0, 2005-06-24 19:12:22Z, Robert Worsnop$

import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.encoding.ser.BaseSerializerFactory;
import org.jboss.webservice.deployment.BeanXMLMetaData;

import javax.xml.namespace.QName;

/** A factory for the MetaDataBeanSerializer
 *
 * @author thomas.diesler@jboss.org
 */
public class MetaDataBeanSerializerFactory extends BaseSerializerFactory
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 2678054736500907260L;

   private BeanXMLMetaData metaData;

   public MetaDataBeanSerializerFactory(Class javaType, QName xmlType)
   {
      super(MetaDataBeanSerializer.class, xmlType, javaType);
   }

   public void setMetaData(BeanXMLMetaData metaData)
   {
      this.metaData = metaData;
   }

   protected Serializer getSpecialized(String mechanismType)
   {
      return new MetaDataBeanSerializer(javaType, xmlType, metaData);
   }

   protected Serializer getGeneralPurpose(String mechanismType)
   {
      return new MetaDataBeanSerializer(javaType, xmlType, metaData);
   }
}
