/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.deployment;

// $Id:MetaDataRegistry.java,v 1.0, 2005-06-24 19:12:23Z, Robert Worsnop$

import org.jboss.logging.Logger;

import javax.xml.namespace.QName;
import java.util.HashMap;

/**
 * A registry that holds typeMapping child elements.
 * <p/>
 * For example the ws4ee-deployment.xml may contain a typeMapping like this, then
 * the <typeDesc> element will be registered under the qname {http://MarshallTest.org/xsd}AllStruct
 * <p/>
 * <typeMapping
 *    qname='ns1:AllStruct' xmlns:ns1='http://MarshallTest.org/xsd'
 *    type='java:org.jboss.ws4ee.test.marshalltest.rpcenc.AllStruct'
 *    serializer='org.jboss.ws4ee.test.marshalltest.rpcenc.ser.AllStructSerializerFactory'
 *    deserializer='org.jboss.ws4ee.test.marshalltest.rpcenc.ser.AllStructDeserializerFactory'
 *    encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'>
 *    <typeDesc >
 *       <elementDesc fieldName="varBase64Binary" xmlName="varBase64Binary" xmlType="xsd:base64Binary"/>
 *       <elementDesc fieldName="varHexBinary" xmlName="varHexBinary" xmlType="xsd:hexBinary"/>
 *       <elementDesc fieldName="varSoapString" xmlName="varSoapString" xmlType="soapenc:string"/>
 *       <elementDesc fieldName="varSoapBoolean" xmlName="varSoapBoolean" xmlType="soapenc:boolean"/>
 *       <elementDesc fieldName="varSoapFloat" xmlName="varSoapFloat" xmlType="soapenc:float"/>
 *       <elementDesc fieldName="varSoapDouble" xmlName="varSoapDouble" xmlType="soapenc:double"/>
 *       <elementDesc fieldName="varSoapDecimal" xmlName="varSoapDecimal" xmlType="soapenc:decimal"/>
 *       <elementDesc fieldName="varSoapInt" xmlName="varSoapInt" xmlType="soapenc:int"/>
 *       <elementDesc fieldName="varSoapShort" xmlName="varSoapShort" xmlType="soapenc:short"/>
 *       <elementDesc fieldName="varSoapByte" xmlName="varSoapByte" xmlType="soapenc:byte"/>
 *       <elementDesc fieldName="varSoapBase64" xmlName="varSoapBase64" xmlType="soapenc:base64"/>
 *    </typeDesc>
 * </typeMapping>
 *
 * @author thomas.diesler@jboss.org
 * @since 08-June-2004
 */
public class MetaDataRegistry
{
   // provide logging
   private final Logger log = Logger.getLogger(MetaDataRegistry.class);

   private HashMap typeMappingMetaData = new HashMap();

   public void registerTypeMappingMetaData(TypeMappingDescription typeMapping)
   {
      QName qname = typeMapping.getTypeQName();
      BeanXMLMetaData metaData = typeMapping.getMetaData();
      if (metaData == null)
         throw new IllegalArgumentException("Cannot register null meta data");

      if (isTypeMappingMetaDataRegisterd(qname) == false || typeMapping.isUserDefined())
      {
         log.debug("Register type mapping meta data for: " + qname);
         typeMappingMetaData.put(qname, metaData);
      }
      else
      {
         log.debug("Ignore register type mapping meta data for: " + qname);
      }
   }

   public BeanXMLMetaData getTypeMappingMetaData(QName typeName)
   {
      return (BeanXMLMetaData)typeMappingMetaData.get(typeName);
   }

   public boolean isTypeMappingMetaDataRegisterd(QName typeName)
   {
      return typeMappingMetaData.get(typeName) != null;
   }

   public void unregisterTypeMappingMetaData(QName typeName)
   {
      typeMappingMetaData.remove(typeName);
   }
}
