/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:OrganizationClientServlet.java,v 1.0, 2005-06-24 19:13:32Z, Robert Worsnop$

import org.jboss.logging.Logger;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.Service;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * An example of a webservice client servlet
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrganizationClientServlet extends HttpServlet
{
   // provide logging
   private static final Logger log = Logger.getLogger(OrganizationClientServlet.class);

   protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
   {
      String info = null;

      String endpoint = req.getParameter("endpoint");
      String method = req.getParameter("method");
      String organization = req.getParameter("organization");
      if ("EJB".equals(endpoint))
      {
         if ("info".equals(method))
            info = getContactInfoEJB(organization);
      }
      if ("JSE".equals(endpoint))
      {
         if ("info".equals(method))
            info = getContactInfoJSE(organization);
      }

      PrintWriter out = res.getWriter();
      out.print(info);
      out.close();
   }

   /** Get the contact info from the EJB service */
   public String getContactInfoEJB(String organization) throws ServletException
   {
      Service service = null;
      try
      {
         InitialContext iniCtx = new InitialContext();
         service = (Service)iniCtx.lookup("java:/comp/env/service/OrganizationServiceEJB");
         Organization endpoint = (Organization)service.getPort(Organization.class);
         String info = endpoint.getContactInfo(organization);
         return info;
      }
      catch (NamingException e)
      {
         throw new ServletException(e);
      }
      catch (Exception e)
      {
         throw new ServletException("Cannot invoke webservice", e);
      }
   }

   /** Get the contact info from the JSE service */
   public String getContactInfoJSE(String organization) throws ServletException
   {
      try
      {
         InitialContext iniCtx = new InitialContext();
         OrganizationService service = (OrganizationService)iniCtx.lookup("java:comp/env/service/OrganizationServiceJSE");
         Organization endpoint = (Organization)service.getOrganizationPort();
         String info = endpoint.getContactInfo(organization);
         return info;
      }
      catch (NamingException e)
      {
         throw new ServletException(e);
      }
      catch (Exception e)
      {
         throw new ServletException("Cannot invoke webservice", e);
      }
   }
}
