/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:ClientSideEJBTestCase.java,v 1.0, 2005-06-24 18:58:05Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.naming.InitialContext;

/**
 * Test access to the webservice via an EJB client
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ClientSideEJBTestCase extends JBossTestCase
{

   public ClientSideEJBTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ClientSideEJBTestCase.class, "ws4ee-samples-server-jse.war, ws4ee-samples-server-ejb.jar, ws4ee-samples-client-ejb.jar");
   }

   /** Test access to the webservice via an EJB client */
   public void testClientAccessEJB() throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      OrganizationClientHome home = (OrganizationClientHome)iniCtx.lookup("ejb/OrganizationClientBean");
      OrganizationClientRemote bean = home.create();
      String info = bean.getContactInfoEJB("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }

   /** Test access to the webservice via an EJB client */
   public void testClientAccessJSE() throws Exception
   {
      InitialContext iniCtx = new InitialContext();
      OrganizationClientHome home = (OrganizationClientHome)iniCtx.lookup("ejb/OrganizationClientBean");
      OrganizationClientRemote bean = home.create();
      String info = bean.getContactInfoJSE("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }
}
