/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.scheduler;

import java.net.URL;

/**
 * A round robin scheduler.
 * @jmx:mbean name="jboss.web.loadbalancer: service=RoundRobinScheduler"
 *            extends="org.jboss.web.loadbalancer.scheduler.AbstractSchedulerMBean"
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 */
public class RoundRobinSchedulerService
    extends AbstractScheduler implements RoundRobinSchedulerServiceMBean {
  private int index = 0;
  public RoundRobinSchedulerService() {
  }

  protected Host getNextHost() {
    Host host = null;
    try
    {
      host = (Host) hostsUp.get(index++);
    }
    catch (IndexOutOfBoundsException iobex)
    {
      index = 0;
    }
    return host;
  }
}
