/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.varia.stats;

import org.jboss.tm.TransactionLocal;

import javax.transaction.Transaction;
import javax.transaction.Synchronization;
import javax.transaction.Status;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class TxStatistics
{
   private final Map reports = new HashMap();
   private final Set collectedItemNames = new HashSet();

   private final TransactionLocal txReport = new TransactionLocal()
   {
      protected Object initialValue()
      {
         Transaction tx = getTransaction();
         TxReport report;
         if(tx != null)
         {
            report = new TxReport();
            try
            {
               tx.registerSynchronization(new TxSynchronization(report));
            }
            catch(Exception e)
            {
               e.printStackTrace();
               throw new IllegalStateException("Failed to register tx synchronization: " + e.getMessage());
            }
         }
         else
         {
            report = null;
         }
         return report;
      }
   };

   public String[] getCollectedItemNames()
   {
      return (String[])collectedItemNames.toArray(new String[collectedItemNames.size()]);
   }

   public Iterator getReports()
   {
      return reports.values().iterator();
   }

   public synchronized void clear()
   {
      reports.clear();
      collectedItemNames.clear();
   }

   public synchronized void addStatisticalItem(StatisticalItem item)
   {
      TxReport report = (TxReport) txReport.get();
      if(report != null)
      {
         boolean addedNew = report.addItem(item);
         if(addedNew)
         {
            collectedItemNames.add(item.getName());
         }
      }
   }

   private synchronized void addReport(TxReport report)
   {
      TxReport oldReport = (TxReport)reports.get(report.getName());
      if(oldReport == null)
      {
         reports.put(report.getName(), report);
      }
      else
      {
         oldReport.merge(report);
      }
   }

   public TxReport getReports(String reportName)
   {
      return (TxReport)reports.get(reportName);
   }

   // Inner

   private class TxSynchronization implements Synchronization
   {
      private final TxReport report;

      public TxSynchronization(TxReport report)
      {
         this.report = report;
      }

      public void beforeCompletion()
      {
      }

      public void afterCompletion(int status)
      {
         if(status != Status.STATUS_ROLLEDBACK)
         {
            try
            {
               addReport(report);
            }
            catch(Exception e)
            {
               e.printStackTrace();
            }
         }
      }
   }
}
