/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.tools;

import java.io.ObjectStreamClass;
import java.io.Serializable;

/**
 * Encapsulates a class serialVersionUID and codebase.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class ClassVersionInfo implements Serializable
{
   static final long serialVersionUID = 2036506209171911437L;

   /** The named class serialVersionUID as returned by ObjectStreamClass */
   private long serialVersion;
   /** The binary class name */
   private String name;
   private boolean hasExplicitSerialVersionUID;

   public ClassVersionInfo(String name, ClassLoader loader)
      throws ClassNotFoundException
   {
      this.name = name;
      Class c = loader.loadClass(name);
      ObjectStreamClass osc = ObjectStreamClass.lookup(c);
      if( osc != null )
      {
         serialVersion = osc.getSerialVersionUID();
         try
         {
            c.getDeclaredField("serialVersionUID");
            hasExplicitSerialVersionUID = true;
         }
         catch(NoSuchFieldException e)
         {
            hasExplicitSerialVersionUID = false;
         }
      }
   }

   public long getSerialVersion()
   {
      return serialVersion;
   }
   public boolean getHasExplicitSerialVersionUID()
   {
      return hasExplicitSerialVersionUID;
   }
   public String getName()
   {
      return name;
   }

   public String toString()
   {
      StringBuffer tmp = new StringBuffer("ClassVersionInfo");
      tmp.append('{');
      tmp.append("serialVersion=");
      tmp.append(serialVersion);
      tmp.append(", hasExplicitSerialVersionUID=");
      tmp.append(hasExplicitSerialVersionUID);
      tmp.append(", name=");
      tmp.append(name);
      tmp.append('}');
      return tmp.toString();
   }
}
