/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.services.deployment.metadata;

import java.io.Serializable;

/**
 * Simple POJO class to model XML data
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class TemplateInfo
   implements Serializable
{
   /** @since 4.0.2 */
   private static final long serialVersionUID = 2231674463239010529L;
      
   private String input;
   private String output;
   
   public TemplateInfo()
   {
      // empty
   }
   
   public TemplateInfo(String input, String output)
   {
      this.input  = input;
      this.output = output;
   }
   
   public String getInput()
   {
      return input;
   }
   
   public void setInput(String input)
   {
      this.input = input;
   }
   
   public String getOutput()
   {
      return output;
   }
   
   public void setOutput(String output)
   {
      this.output = output;
   }
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(128);
      
      sbuf.append('[')
      .append("input=").append(input)
      .append(", output=").append(output)
      .append(']');
      
      return sbuf.toString();      
   }   
}
