/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.services.deployment.metadata;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;

import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.xml.sax.Attributes;

/**
 * Class that implements the binding of the XML model
 * to our POJO classes, using the GenericObjectModelFactory
 * facility
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class ConfigInfoBinding
   implements GenericObjectModelFactory
{
         
   // GenericObjectModelFactory implementation ----------------------
   
   public Object newRoot(Object root, ContentNavigator navigator, String namespaceURI,
                         String localName, Attributes attrs)
   {
      final ConfigInfo ci;
      if(root == null)
      {
         root = ci = new ConfigInfo();
      }
      else
      {
         ci = (ConfigInfo) root;
      }

      if(attrs.getLength() > 0)
      {
         for(int i = 0; i < attrs.getLength(); ++i)
         {
            if (attrs.getLocalName(i).equals("copydir"))
            {
               ci.setCopydir(attrs.getValue(i));
            }
            else if (attrs.getLocalName(i).equals("template"))
            {
               ci.setTemplate(attrs.getValue(i));
            }
            else if (attrs.getLocalName(i).equals("extension"))
            {
               ci.setExtension(attrs.getValue(i));
            }
         }
      }
      return root;
   }
   
   public Object newChild(Object parent, ContentNavigator navigator, String namespaceURI,
                          String localName, Attributes attrs)
   {
      Object child = null;

      if (parent instanceof ConfigInfo)
      {
         if("property".equals(localName))
         {
            PropertyInfo pi = new PropertyInfo();
            child = pi;
   
            if(attrs.getLength() > 0)
            {
               for(int i = 0; i < attrs.getLength(); ++i)
               {
                  if(attrs.getLocalName(i).equals("name"))
                  {  
                     pi.setName(attrs.getValue(i));
                  }
                  else if (attrs.getLocalName(i).equals("type"))
                  {
                     pi.setType(attrs.getValue(i));
                  }
                  else if (attrs.getLocalName(i).equals("optional"))
                  {
                     pi.setOptional(Boolean.valueOf(attrs.getValue(i)).booleanValue());
                  }
               }
            }
            if (pi.getName() == null)
               throw new RuntimeException(
                  "Missing attribute 'name' for <property> element");
            
            // check type if specified, otherwise assume the default
            String type = pi.getType();
            if (type == null)
               pi.setType("java.lang.String");
         }
         else if ("template".equals(localName))
         {
            TemplateInfo ti = new TemplateInfo();
            child = ti;
            
            if(attrs.getLength() > 0)
            {
               for(int i = 0; i < attrs.getLength(); ++i)
               {
                  if(attrs.getLocalName(i).equals("input"))
                  {  
                     ti.setInput(attrs.getValue(i));
                  }
                  else if (attrs.getLocalName(i).equals("output"))
                  {
                     ti.setOutput(attrs.getValue(i));
                  }
               }
            }
            // check both attributes are populated
            if (ti.getInput() == null || ti.getOutput() == null)
               throw new RuntimeException(
                  "Both 'input' and 'output' attribute must be set for a <template> element");
         }
      }
      return child;
   }

   public void addChild(Object parent, Object child, ContentNavigator navigator,
                        String namespaceURI, String localName)
   {
      if(parent instanceof ConfigInfo)
      {
         final ConfigInfo ci = (ConfigInfo)parent;
         if(child instanceof PropertyInfo)
         {
            ci.addPropertyInfo((PropertyInfo)child);
         }
         else if(child instanceof TemplateInfo)
         {
            ci.addTemplateInfo((TemplateInfo)child);
         }
      }      
   }

   public void setValue(Object o, ContentNavigator navigator, String namespaceURI,
                        String localName, String value)
   {
      if(o instanceof ConfigInfo)
      {
         final ConfigInfo ci = (ConfigInfo)o;
         if("description".equals(localName))
         {
            ci.setDescription(value);
         }
      }
      else if(o instanceof PropertyInfo)
      {
         PropertyInfo pi = (PropertyInfo)o;
         if("description".equals(localName))
         {
            pi.setDescription(value);
         }
         else if("default-value".equals(localName))
         {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class clazz = null;
            try {
               clazz = cl.loadClass(pi.getType());
            }
            catch (ClassNotFoundException e) {
               throw new RuntimeException("Class not found for property '" + pi.getName() +
                                    "' of type '" + pi.getType() + "'");
            }
            PropertyEditor peditor = PropertyEditorManager.findEditor(clazz);

            if (peditor != null) {
               peditor.setAsText(value);
               pi.setDefaultValue(peditor.getValue());
            }
            else
               throw new RuntimeException("Property editor not found for property '" + pi.getName() +
                                    "' of type '" + pi.getType() + "'");
         }
      }
   }

   public Object completedRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName)
   {
      return root;
   }
}
