/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.services.deployment;

import org.jboss.logging.Logger;

/**
 * Helper class to pass in to velocity templates and
 * do things that are more easily performed in java code.
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision:1$
 */
public final class ContextHelper
{
   // Static --------------------------------------------------------
   
   /** the Logger instance */
   private static final Logger log = Logger.getLogger(ContextHelper.class);
   
   // Private Data --------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   /**
    * Default CTOR
    */
   public ContextHelper()
   {
      // empty
   }
   
   // Public --------------------------------------------------------
   
   /**
    * Convenience method to find out if a variable is defined (not null).
    * This helps particularly to check if a Boolean variable has been
    * passed to the velocity context, since the #if( $boolean )
    * construct is only satisfied, if the value both exists and is true.
    * 
    * @param obj any object
    * @return true if the object is not null, false otherwise
    */
   public static boolean isDefined(Object obj)
   {
      return obj != null ? true : false;
   }
}
