/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.jmx.adaptor.snmp.config.notification;

import java.util.ArrayList;
import java.util.List;

/**
 * Simple POJO class to model XML data
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class VarBindList
{
   // Private Data --------------------------------------------------

   private String wrapperClass;
   private List varBindList = new ArrayList(); 

   // Constructors -------------------------------------------------
   
   /**
    * Default CTOR
    */
   public VarBindList()
   {
      // empty
   }

   // Accessors/Modifiers ------------------------------------------- 

   public String getWrapperClass()
   {
      return wrapperClass;
   }
   
   public List getVarBindList()
   {
      return varBindList;
   }
   
   public void setWrapperClass(String wrapperClass)
   {
      this.wrapperClass = wrapperClass;
   }
   
   public void setVarBindList(List varBindList)
   {
      this.varBindList = varBindList;
   }
   
   public void addVarBind(VarBind varBind)
   {
      varBindList.add(varBind);
   }

   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append('[')
      .append("wrapperClass=").append(wrapperClass)
      .append(", varBindList=").append(varBindList)
      .append(']');
      
      return sbuf.toString();      
   }   
}
