/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.jmx.adaptor.snmp.config.notification;

/**
 * Simple POJO class to model XML data
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class VarBind
{
   // Private Data --------------------------------------------------

   private String tag;
   private String oid;

   // Constructors -------------------------------------------------
   
   /**
    * Default CTOR
    */
   public VarBind()
   {
      // empty
   }

   // Accessors/Modifiers -------------------------------------------
  
   public String getOid()
   {
      return oid;
   } 

   public String getTag()
   {
      return tag;
   }

   public void setOid(String oid)
   {
      this.oid = oid;
   }
   
   public void setTag(String tag)
   {
      this.tag = tag;
   }

   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append('[')
      .append("tag=").append(tag)
      .append(", oid=").append(oid)
      .append(']');
      
      return sbuf.toString();      
   }      
}
