/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

/** A valve that associates the j_username with the session under the attribute
 * name j_username for use by form login/error pages. In addition, it maps any
 * authentication exception found in the SecurityAssociation to the session
 * attribute name j_exception.
 *  
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class FormAuthValve
   extends ValveBase
{
   private static Logger log = Logger.getLogger(FormAuthValve.class);
   private static boolean trace = log.isTraceEnabled();

   public void invoke(Request request, Response response)
      throws IOException, ServletException
   {
      String username = request.getParameter("j_username");
      HttpSession session = request.getSession(false);
      if( trace )
         log.trace("Enter, j_username="+username);
      if( session != null )
         session.setAttribute("j_username", username);

      getNext().invoke(request, response);

      username = request.getParameter("j_username");
      session = request.getSession(false);
      if( session != null )
      {
         if( trace )
           log.trace("SessionID: "+session.getId());
         if( username != null )
            session.setAttribute("j_username", username);
         // Check the SecurityAssociation context exception
         Throwable t = (Throwable) SecurityAssociationActions.getAuthException();
         if( trace )
           log.trace("SecurityAssociation.exception: "+t);
         if( t != null )
            session.setAttribute("j_exception", t);
      }
      if( trace )
         log.trace("Exit, username: "+username);
   }
}
