/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class XMBeanNotificationMetaData
{
   private String description;
   private String name;
   private String notificationType;

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String getNotificationType()
   {
      return notificationType;
   }

   public void setNotificationType(String notificationType)
   {
      this.notificationType = notificationType;
   }

   public String toString()
   {
      return "[name=" + name + ", notification-type=" + notificationType + ", description=" + description + ']';
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof XMBeanNotificationMetaData)) return false;

      final XMBeanNotificationMetaData mBeanNotificationMetaData = (XMBeanNotificationMetaData)o;

      if(description != null ? !description.equals(mBeanNotificationMetaData.description) : mBeanNotificationMetaData.description != null) return false;
      if(name != null ? !name.equals(mBeanNotificationMetaData.name) : mBeanNotificationMetaData.name != null) return false;
      if(notificationType != null ? !notificationType.equals(mBeanNotificationMetaData.notificationType) : mBeanNotificationMetaData.notificationType != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (description != null ? description.hashCode() : 0);
      result = 29 * result + (name != null ? name.hashCode() : 0);
      result = 29 * result + (notificationType != null ? notificationType.hashCode() : 0);
      return result;
   }
}
