/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced;

import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.test.xml.multispaced.pm.jdbc.JDBCPm;
import org.xml.sax.Attributes;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class XMBeanMetaDataFactory
   implements ObjectModelFactory
{
   public static final XMBeanMetaDataFactory INSTANCE = new XMBeanMetaDataFactory();

   private XMBeanMetaDataFactory()
   {
   }

   public Object newRoot(Object root,
                               ContentNavigator navigator,
                               String namespaceURI,
                               String localName,
                               Attributes attrs)
   {
      return root == null ? new XMBeanMetaData() : root;
   }

   public void setValue(XMBeanMetaData xmbean,
                        ContentNavigator navigator,
                        String namespaceUri,
                        String localName,
                        String value)
   {
      if("description".equals(localName))
      {
         xmbean.setDescription(value);
      }
      else if("class".equals(localName))
      {
         xmbean.setMbeanClass(value);
      }
   }

   public Object newChild(XMBeanMetaData xmbean,
                          ContentNavigator navigator,
                          String namespaceUri,
                          String localName,
                          Attributes attrs)
   {
      Object child;
      if("constructor".equals(localName))
      {
         child = new XMBeanConstructorMetaData();
      }
      else if("attribute".equals(localName))
      {
         final XMBeanAttributeMetaData attribute = new XMBeanAttributeMetaData();
         for(int i = 0; i < attrs.getLength(); ++i)
         {
            final String attrName = attrs.getLocalName(i);
            if("access".equals(attrName))
            {
               attribute.setAccess(attrs.getValue(i));
            }
            else if("getMethod".equals(attrName))
            {
               attribute.setGetMethod(attrs.getValue(i));
            }
            else if("setMethod".equals(attrName))
            {
               attribute.setSetMethod(attrs.getValue(i));
            }
         }
         child = attribute;
      }
      else if("operation".equals(localName))
      {
         child = new XMBeanOperationMetaData();
      }
      else if("notification".equals(localName))
      {
         child = new XMBeanNotificationMetaData();
      }
      else
      {
         child = null;
      }

      return child;
   }

   public void addChild(XMBeanMetaData xmbean, XMBeanConstructorMetaData constructor, ContentNavigator navigator, String namespaceURI, String localName)
   {
      xmbean.addConstructor(constructor);
   }

   public void addChild(XMBeanMetaData xmbean, XMBeanAttributeMetaData attribute, ContentNavigator navigator, String namespaceURI, String localName)
   {
      xmbean.addAttribute(attribute);
   }

   public void addChild(XMBeanMetaData xmbean, XMBeanOperationMetaData operation, ContentNavigator navigator, String namespaceURI, String localName)
   {
      xmbean.addOperation(operation);
   }

   public void addChild(XMBeanMetaData xmbean, XMBeanNotificationMetaData notification, ContentNavigator navigator, String namespaceURI, String localName)
   {
      xmbean.addNotification(notification);
   }

   public void addChild(XMBeanMetaData xmbean,
                        Object pm,
                        ContentNavigator navigator,
                        String namespaceURI,
                        String localName)
   {
      xmbean.setPersistenceManager(pm);
   }

   public void setValue(XMBeanConstructorMetaData constructor,
                        ContentNavigator navigator,
                        String namespaceUri,
                        String localName,
                        String value)
   {
      if("description".equals(localName))
      {
         constructor.setDescription(value);
      }
      else if("name".equals(localName))
      {
         constructor.setName(value);
      }
   }

   public void setValue(XMBeanAttributeMetaData attribute,
                        ContentNavigator navigator,
                        String namespaceUri,
                        String localName,
                        String value)
   {
      if("description".equals(localName))
      {
         attribute.setDescription(value);
      }
      else if("name".equals(localName))
      {
         attribute.setName(value);
      }
      else if("type".equals(localName))
      {
         attribute.setType(value);
      }
   }

   public void setValue(XMBeanOperationMetaData operation,
                        ContentNavigator navigator,
                        String namespaceUri,
                        String localName,
                        String value)
   {
      if("description".equals(localName))
      {
         operation.setDescription(value);
      }
      else if("name".equals(localName))
      {
         operation.setName(value);
      }
      else if("return-type".equals(localName))
      {
         operation.setReturnType(value);
      }
   }

   public void setValue(XMBeanNotificationMetaData notification,
                        ContentNavigator navigator,
                        String namespaceUri,
                        String localName,
                        String value)
   {
      if("description".equals(localName))
      {
         notification.setDescription(value);
      }
      else if("name".equals(localName))
      {
         notification.setName(value);
      }
      else if("notification-type".equals(localName))
      {
         notification.setNotificationType(value);
      }
   }
}
