/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class XMBeanConstructorMetaData
{
   private String description;
   private String name;

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public String toString()
   {
      return "[name=" + name + ", description=" + description + ']';
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof XMBeanConstructorMetaData)) return false;

      final XMBeanConstructorMetaData mBeanConstructorMetaData = (XMBeanConstructorMetaData)o;

      if(description != null ? !description.equals(mBeanConstructorMetaData.description) : mBeanConstructorMetaData.description != null) return false;
      if(name != null ? !name.equals(mBeanConstructorMetaData.name) : mBeanConstructorMetaData.name != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (description != null ? description.hashCode() : 0);
      result = 29 * result + (name != null ? name.hashCode() : 0);
      return result;
   }
}
