/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.book;

import java.util.List;
import java.util.ArrayList;

/**
 * Book class that represents book element in XML content.
 *
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class Book
{
   private String isbn;
   private String title;
   private String author;
   private List characters = new ArrayList();

   public String getIsbn()
   {
      return isbn;
   }

   public void setIsbn(String isbn)
   {
      this.isbn = isbn;
   }

   public String getAuthor()
   {
      return author;
   }

   public void setAuthor(String author)
   {
      this.author = author;
   }

   public String getTitle()
   {
      return title;
   }

   public void setTitle(String title)
   {
      this.title = title;
   }

   public List getCharacters()
   {
      return characters;
   }

   public void setCharacters(List characters)
   {
      this.characters = characters;
   }

   public void addCharacter(BookCharacter character)
   {
      characters.add(character);
   }

   public int getCharactersTotal()
   {
      return characters.size();
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer(100);
      sb.append('[')
         .append("isbn=").append(isbn)
         .append(", title=").append(title)
         .append(", author=").append(author)
         .append(", characters=").append(characters)
         .append(']');
      return sb.toString();
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof Book)) return false;

      final Book book = (Book)o;

      if(author != null ? !author.equals(book.author) : book.author != null) return false;
      if(characters != null ? !characters.equals(book.characters) : book.characters != null) return false;
      if(isbn != null ? !isbn.equals(book.isbn) : book.isbn != null) return false;
      if(title != null ? !title.equals(book.title) : book.title != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (isbn != null ? isbn.hashCode() : 0);
      result = 29 * result + (title != null ? title.hashCode() : 0);
      result = 29 * result + (author != null ? author.hashCode() : 0);
      result = 29 * result + (characters != null ? characters.hashCode() : 0);
      return result;
   }
}
