/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml;

import junit.framework.TestCase;
import org.jboss.xml.binding.Util;

/**
 * Tests XML names to various Java identifiers conversion.
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class XMLNameToJavaIdentifierUnitTestCase
   extends TestCase
{
   private static final String[] xmlNames = new String[]
   {
      "mixedCaseName", "Answer42", "name-with-dashes", "other_punct-chars", "one2three", "__-invalids-at-the-end---"
   };

   private static final String[] clsNames = new String[]
   {
      "MixedCaseName", "Answer42", "NameWithDashes", "OtherPunctChars", "One2Three", "InvalidsAtTheEnd"
   };

   private static final String[] clsNamesWithLowLines = new String[]
   {
      "MixedCaseName", "Answer42", "NameWithDashes", "Other_PunctChars", "One2Three", "__InvalidsAtTheEnd"
   };

   private static final String[] getNames = new String[]
   {
      "getMixedCaseName", "getAnswer42", "getNameWithDashes", "getOtherPunctChars", "getOne2Three", "getInvalidsAtTheEnd"
   };

   private static final String[] setNames = new String[]
   {
      "setMixedCaseName", "setAnswer42", "setNameWithDashes", "setOtherPunctChars", "setOne2Three", "setInvalidsAtTheEnd"
   };

   private static final String[] constNames = new String[]
   {
      "MIXED_CASE_NAME", "ANSWER_42", "NAME_WITH_DASHES", "OTHER_PUNCT_CHARS", "ONE_2_THREE", "INVALIDS_AT_THE_END"
   };

   public XMLNameToJavaIdentifierUnitTestCase(String localName)
   {
      super(localName);
   }

   public void testXmlNameToClassName() throws Exception
   {
      for(int i = 0; i < xmlNames.length; ++i)
      {
         String clsName = Util.xmlNameToClassName(xmlNames[i], true);
         assertEquals(clsNames[i], clsName);
      }
   }

   public void testXmlNameToClassNameWithLowLines() throws Exception
   {
      for(int i = 0; i < xmlNames.length; ++i)
      {
         String clsName = Util.xmlNameToClassName(xmlNames[i], false);
         assertEquals(clsNamesWithLowLines[i], clsName);
      }
   }

   public void testXmlNameToGetMethodName() throws Exception
   {
      for(int i = 0; i < xmlNames.length; ++i)
      {
         String clsName = Util.xmlNameToGetMethodName(xmlNames[i], true);
         assertEquals(getNames[i], clsName);
      }
   }

   public void testXmlNameToSetMethodName() throws Exception
   {
      for(int i = 0; i < xmlNames.length; ++i)
      {
         String clsName = Util.xmlNameToSetMethodName(xmlNames[i], true);
         assertEquals(setNames[i], clsName);
      }
   }

   public void testXmlNameToConstantName() throws Exception
   {
      for(int i = 0; i < xmlNames.length; ++i)
      {
         String clsName = Util.xmlNameToConstantName(xmlNames[i]);
         assertEquals(constNames[i], clsName);
      }
   }
}
