/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml;

// $Id:RARTestCase.java,v 1.0, 2005-06-24 19:14:37Z, Robert Worsnop$

import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;
import org.jboss.xml.binding.ObjectModelFactory;
import org.xml.sax.InputSource;
import junit.framework.TestCase;

import java.net.URL;
import java.io.FileInputStream;


/**
 * Test the unmarshalling of ra.xml files
 *
 * @author Thomas.Diesler@jboss.org
 */
public class RARTestCase
   extends TestCase
{
   private Unmarshaller unmarshaller;
   private InputSource  inputSource;

   public RARTestCase(String name)
   {
      super(name);
   }

   // Setup the Unmarshaller & resource stream
   protected void setUp() throws Exception
   {
      super.setUp();

      unmarshaller = new Unmarshaller();
      String resourceName = "xml/" + getName() + ".xml";
      final URL resource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
      assertNotNull("Null resource", resource);
      inputSource = new InputSource(new FileInputStream(resource.getFile()));
   }

   /**
    * Test if we can unmarshal a ra.xml without DTD
    */
   public void testRARwithoutDTD() throws Exception
   {
      ObjectModelFactory factory = new ResourceAdapterObjectModelFactory();
      Object metaData = unmarshaller.unmarshal(inputSource, factory, null);
      assertNotNull("Null meta data", metaData);
   }

   /**
    * Test if we can unmarshal a ra.xml with DTD
    */
   public void testRARwithDTD() throws Exception
   {
      ObjectModelFactory factory = new ResourceAdapterObjectModelFactory();
      Object metaData = unmarshaller.unmarshal(inputSource, factory, null);
      assertNotNull("Null meta data", metaData);
   }

   /**
    * Test if we can unmarshal a ra.xml with DTD
    */
   public void testRARwithSchema() throws Exception
   {
      ObjectModelFactory factory = new ResourceAdapterObjectModelFactory();
      Object metaData = unmarshaller.unmarshal(inputSource, factory, null);
      assertNotNull("Null meta data", metaData);
   }
}
