/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.ws4eesimple;

// $Id:SimpleEJBTestCase.java,v 1.0, 2005-06-24 19:16:20Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * Tests of the ws4ee functionality for a simple Hello EJB.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 06-May-2004
 */
public class SimpleEJBTestCase extends JBossTestCase
{
   private final String WSDL_LOCATION = "http://" + getServerHost() + ":8080/ws4ee-simple?wsdl";
   private String NAMESPACE = "http://test.jboss.org/ws4eesimple";
   private final QName SERVICE_NAME = new QName(NAMESPACE, "HelloWsService");

   /**
    * Construct the test case with a given name
    */
   public SimpleEJBTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(SimpleJSETestCase.class, "ws4ee-simple.jar");
   }

   /**
    * test simple EJB access
    */

   public void testSayHello() throws Exception
   {
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
      Service service = serviceFactory.createService(new URL(WSDL_LOCATION), SERVICE_NAME);
      Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPortComponent"), "sayHello");
      String retstr = (String)call.invoke(new Object[]{"Hello"});
      assertEquals("'Hello' to you too!", retstr);
   }
}
