/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.ws4eesimple;

// $Id:SimpleClientTestCase.java,v 1.0, 2005-06-24 19:16:19Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

/**
 * Tests of the ws4ee functionality for a simple Hello EJB.
 *
 * @author Thomas.Diesler@jboss.org
 * @author Christoph.Jung@infor.de
 * @since 06-May-2004
 */
public class SimpleClientTestCase extends WebserviceTestBase
{

   /**
    * Construct the test case with a given name
    */
   public SimpleClientTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(SimpleClientTestCase.class, "ws4ee-simple.jar, ws4ee-simple-client.ear");
   }

   /**
    * Test client application access
    */
   public void testApplClient() throws Exception
   {
      Context envCtx = getClientContext();
      Object obj = envCtx.lookup("java:comp/env/service/HelloWsService");
      assertTrue("Is not a javax.xml.rpc.Service, but: " + obj, javax.xml.rpc.Service.class.isAssignableFrom(obj.getClass()));
      Service service = (Service)obj;
      HelloWs ws = (HelloWs)service.getPort(HelloWs.class);
      String res = ws.sayHello("Hello");
      assertEquals("'Hello' to you too!", res);
   }

   /**
    * Test servlet client access
    */
   public void testWebClient() throws Exception
   {
      URL url = new URL("http://" + getServerHost() + ":8080/ws4ee-simple-client/HelloWsClientServlet?input=Hello");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      String res = br.readLine();
      br.close();

      assertEquals("'Hello' to you too!", res);
   }

   /**
    * Test EJB client access
    */
   public void testEJBClient() throws Exception
   {
      // test direct EJB access
      InitialContext iniCtx = getClientContext();
      HelloHome home = (HelloHome)iniCtx.lookup("java:comp/env/HelloClientEjb");
      Hello ejb = home.create();

      String output = ejb.sayHello("Hello");
      assertEquals("'Hello' to you too!", output);

      // test webservice access
      Context envCtx = getClientContext();
      javax.xml.rpc.Service svc = (javax.xml.rpc.Service)envCtx.lookup("java:comp/env/service/HelloWsService");

      HelloWs sei = (HelloWs)svc.getPort(HelloWs.class);
      output = sei.sayHello("Hello");
      assertEquals("'Hello' to you too!", output);
   }
}
