/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.ws4eesimple;

import org.jboss.logging.Logger;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import java.rmi.RemoteException;

public class HelloBean implements SessionBean
{
   private Logger log = Logger.getLogger(HelloBean.class);

   public HelloBean()
   {
      log.debug("new HelloBean");
   }

   // business methods *************************************************************************************************

   public String sayHello(String input) throws RemoteException
   {
      log.debug("sayHello: " + input);
      return "'" + input + "' to you too!";
   }

   // EJB life cycle methods *******************************************************************************************

   public void ejbCreate()
   {
      log.debug("ejbCreate");
   }

   public void ejbRemove()
   {
      log.debug("ejbRemove");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate");
   }

   public void setSessionContext(SessionContext sc)
   {
      log.debug("setSessionContext");
   }
}
