/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2;

// $Id:Person.java,v 1.0, 2005-06-24 19:14:00Z, Robert Worsnop$

/**
 * An example of a complex user type
 *
 * @author Thomas.Diesler@jboss.org
 * @since 12-Feb-2005
 */
public class Person
{
   private String name;
   private int age;

   public Person()
   {
   }

   public Person(String name, int age)
   {
      this.age = age;
      this.name = name;
   }

   public int getAge()
   {
      return age;
   }

   public void setAge(int age)
   {
      this.age = age;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (!(o instanceof Person)) return false;

      final Person person = (Person)o;

      if (age != person.age) return false;
      if (!name.equals(person.name)) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = name.hashCode();
      result = 29 * result + age;
      return result;
   }

   public String toString()
   {
      return "[name=" + name + ",age=" + age + "]";
   }
}
