/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2;


// $Id:OrderProcessRPCTestCase.java,v 1.0, 2005-06-24 19:13:30Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Test access to a complex rpc/literal endpoint
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrderProcessRPCTestCase extends WebserviceTestBase
{

   public OrderProcessRPCTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(OrderProcessRPCTestCase.class, "ws4ee-samples2-rpc.war, ws4ee-samples2-rpc-client.jar");
   }

   /** Test a valid access */
   public void testValidAccess() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = (OrderProcess)service.getPort(OrderProcess.class);

      Person p = new Person("Tom", 3);
      OrderItem i0 = new OrderItem("Ferrari", 1);
      OrderItem i1 = new OrderItem("Twix", 10);
      OrderItem i2 = new OrderItem("IceCream", 3);

      OrderResponse res = endpoint.processOrder(new OrderItem[]{i0, i1, i2}, p);
      assertEquals(3, res.getItems().length);
      assertEquals(i0, res.getItems()[0]);
      assertEquals(i1, res.getItems()[1]);
      assertEquals(i2, res.getItems()[2]);
      assertEquals("aproved", res.getMessage());
   }

   /** Test a valid access */
   public void testNullPerson() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = (OrderProcess)service.getPort(OrderProcess.class);

      OrderItem i1 = new OrderItem("Ferrari", 1);
      OrderItem i2 = new OrderItem("Twix", 10);
      OrderItem i3 = new OrderItem("IceCream", 3);

      try
      {
         endpoint.processOrder(new OrderItem[]{i1, i2, i3}, null);
         fail("OrderException expected");
      }
      catch (OrderException e)
      {
         // ignore expected exception
      }
   }

   /** Test a valid access */
   public void testTooManyItems() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = (OrderProcess)service.getPort(OrderProcess.class);

      Person p = new Person("Tom", 3);
      OrderItem i1 = new OrderItem("Ferrari", 1);
      OrderItem i2 = new OrderItem("Twix", 10);
      OrderItem i3 = new OrderItem("IceCream", 3);
      OrderItem i4 = new OrderItem("GameBoy", 1);

      try
      {
         endpoint.processOrder(new OrderItem[]{i1, i2, i3, i4}, p);
         fail("OrderException expected");
      }
      catch (OrderException e)
      {
         // ignore expected exception
      }
   }
}
