/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2;

// $Id:OrderItem.java,v 1.0, 2005-06-24 19:13:29Z, Robert Worsnop$

/**
 * An example of a complex user type
 *
 * @author Thomas.Diesler@jboss.org
 * @since 12-Feb-2005
 */
public class OrderItem
{
   private String name;
   private int quantity;

   public OrderItem()
   {
   }

   public OrderItem(String name, int quantity)
   {
      this.quantity = quantity;
      this.name = name;
   }

   public int getQuantity()
   {
      return quantity;
   }

   public void setQuantity(int quantity)
   {
      this.quantity = quantity;
   }

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (!(o instanceof OrderItem)) return false;

      final OrderItem orderItem = (OrderItem)o;

      if (quantity != orderItem.quantity) return false;
      if (!name.equals(orderItem.name)) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = name.hashCode();
      result = 29 * result + quantity;
      return result;
   }

   public String toString()
   {
      return "[name=" + name + ",quantity=" + quantity + "]";
   }
}
