/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples;

// $Id:ServerSideJSETestCase.java,v 1.0, 2005-06-24 19:15:56Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * An example that accesses a java service endpoint
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class ServerSideJSETestCase extends JBossTestCase
{
   public ServerSideJSETestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ServerSideJSETestCase.class, "ws4ee-samples-server-jse.war");
   }

   public void testJSEEndpointAccess() throws Exception
   {
      URL url = new URL("http://localhost:8080/ws4ee-samples-server-jse/Organization?wsdl");
      QName qname = new QName("http://org.jboss.test.webservice/samples", "OrganizationService");

      ServiceFactory factory = ServiceFactory.newInstance();
      Service service = factory.createService(url, qname);
      Organization endpoint = (Organization)service.getPort(Organization.class);

      String info = endpoint.getContactInfo("mafia");
      assertEquals("The 'mafia' boss is currently out of office, please call again.", info);
   }
}
