/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.marshalltest.types;

import java.text.SimpleDateFormat;
import java.util.Calendar;

// $Id:CalendarArr.java,v 1.0, 2005-06-24 18:56:21Z, Robert Worsnop$

/**
 * Created by IntelliJ IDEA.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 24-Sep-2004
 */
public class CalendarArr
{
   private Calendar[] calendarArr;

   public CalendarArr()
   {
   }

   public CalendarArr(Calendar[] calendarArr)
   {
      this.calendarArr = calendarArr;
   }

   public Calendar[] getCalendarArr()
   {
      return calendarArr;
   }

   public void setCalendarArr(Calendar[] calendarArr)
   {
      this.calendarArr = calendarArr;
   }

   public boolean equals(Object obj)
   {
      return toString().equals("" + obj);
   }

   public String toString()
   {
      SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
      if (calendarArr != null)
      {
         StringBuffer ret = new StringBuffer("[");
         for (int i = 0; i < calendarArr.length; i++)
         {
            Calendar cal = calendarArr[i];
            String str = sdf.format(cal.getTime());
            ret.append(i == 0 ? str : "," + str);
         }
         ret.append("]");
         return ret.toString();
      }
      else
      {
         return "[]";
      }
   }
}
