/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.marshalltest;

// $Id:MarshallRpcLiteralTestCase.java,v 1.0, 2005-06-24 19:11:41Z, Robert Worsnop$

import junit.framework.Test;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Tests of the ws4ee rpc/literal marshalling
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-May-2004
 */
public class MarshallRpcLiteralTestCase extends AbstractRpcTestBase
{
   /**
    * Construct the test case with a given name
    */
   public MarshallRpcLiteralTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(MarshallRpcLiteralTestCase.class, "ws4ee-marshall-rpclit.ear");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      if (rpcPort == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/MarshallRpcLitService");
         rpcPort = (MarshallRpcServiceInterface)service.getPort(MarshallRpcServiceInterface.class);
      }
   }
}
