/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws84;

// $Id:JBWS84TestCase.java,v 1.0, 2005-06-24 19:09:17Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;
import org.w3c.dom.Document;

import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.Service;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;

/**
 * Test unstructured message processing
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class JBWS84TestCase extends WebserviceTestBase
{

   public JBWS84TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS84TestCase.class, "ws4ee-jbws84.war, ws4ee-jbws84-client.jar");
   }

   /** Use the JBoss generated dynamic proxy send the SOAP message.
    * This tests server/client side message handling.
    */
   public void testProcessSOAPElement() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/MessageService");
      Message port = (Message)service.getPort(Message.class);

      MessageFactory factory = MessageFactory.newInstance();
      SOAPMessage reqMessage = factory.createMessage();

      DocumentBuilder builder = getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(Message.request.getBytes()));
      reqMessage.getSOAPBody().addDocument(doc);

      SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
      SOAPBody soapBody = soapEnvelope.getBody();
      SOAPElement reqElement = (SOAPElement)soapBody.getChildElements().next();

      SOAPElement resElement = port.processSOAPElement(reqElement);
      validateResponse(resElement);
   }

   private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException
   {
      // Setup document builder
      DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
      docBuilderFactory.setNamespaceAware(true);

      DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
      return builder;
   }

   private void validateResponse(SOAPElement soapElement)
           throws SOAPException
   {
      SOAPFactory factory = SOAPFactory.newInstance();

      Name expName = factory.createName("Response", Message.PREFIX, Message.NAMESPACE_URI);
      Name elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      expName = factory.createName("POID");
      soapElement = (SOAPElement)soapElement.getChildElements(expName).next();
      elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      String elementValue = soapElement.getValue();
      assertEquals("12345", elementValue);

      expName = factory.createName("Status");
      soapElement = (SOAPElement)soapElement.getNextSibling();
      elementName = soapElement.getElementName();
      assertEquals(expName, elementName);

      elementValue = soapElement.getValue();
      assertEquals("ok", elementValue);
   }
}
