/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws79;

// $Id:JBWS79TestCase.java,v 1.0, 2005-06-24 19:09:17Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;

/**
 * Cannot deploy a ws containing more than one service per wsdl
 *
 * http://jira.jboss.com/jira/browse/JBWS-79
 *
 * @author Thomas.Diesler@jboss.org
 * @since 08-Feb-2005
 */
public class JBWS79TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS79TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS79TestCase.class, "ws4ee-jbws79.war, ws4ee-jbws79-client.jar");
   }

   /** Test endpoint one
    */
   public void testEndpointOne() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloOneService");
      HelloOne hello = (HelloOne)service.getPort(HelloOne.class);

      String in0 = "Kermit";
      assertEquals(in0, hello.echoString(in0));
   }

   /** Test endpoint two
    */
   public void testEndpointTwo() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloTwoService");
      HelloTwo hello = (HelloTwo)service.getPort(HelloTwo.class);

      QName in0 = new QName("http://somens", "Kermit");
      assertEquals(in0, hello.echoQName(in0));
   }
}
