/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws68;

// $Id:JBWS68TestCase.java,v 1.0, 2005-06-24 19:09:15Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * The type associated with a message part references a complex schema type and not a schema element that uses the schema type.
 *
 * <message name="ItolEndPoint_getAccountResponse">
 *   <part name="result" type="ns2:AccountTO"/>
 * </message>
 *
 * For the element name jboss-4.0.1 defaults to the schema type name instead of the wsdl part name, which indeed is probably incorrect.
 *
 * http://jira.jboss.com/jira/browse/JBWS-68
 *
 * @author Thomas.Diesler@jboss.org
 * @since 08-Feb-2005
 */
public class JBWS68TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS68TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS68TestCase.class, "ws4ee-jbws68.war, ws4ee-jbws68-client.jar");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      Hello hello = (Hello)service.getPort(Hello.class);

      UserType in0 = new UserType("Kermit");
      UserType retObj = hello.echoUserType(in0);
      assertEquals(in0, retObj);
   }
}
