/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws153;

// $Id:JBWS153TestCase.java,v 1.0, 2005-06-24 19:09:15Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/** Test nested xsd imports
 *
 *  http://jira.jboss.com/jira/browse/JBWS-153
 *
 * @author Thomas.Diesler@jboss.org
 * @since 22-Mar-2005
 */
public class JBWS153TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS153TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS153TestCase.class, "ws4ee-jbws153.war, ws4ee-jbws153-client.jar");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      InitialContext iniContext = getClientContext();
      Service service = (Service)iniContext.lookup("java:comp/env/service/OrderService");
      Order port = (Order)service.getPort(Order.class);

      String getMessage = "Ferrari";
      String retStr = port.getOrder(getMessage);
      assertEquals(getMessage, retStr);
   }
}
