/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.jbws128;

import org.jboss.logging.Logger;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.Service;
import java.io.IOException;
import java.io.PrintWriter;

public class HelloClientServlet extends HttpServlet
{
   private Logger log = Logger.getLogger(HelloClientServlet.class);

   protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
   {
      try
      {
         InitialContext iniCtx = new InitialContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
         Hello hello = (Hello)service.getPort(Hello.class);

         log.info("Got port: " + hello);

         res.setContentType("text/plain");
         PrintWriter out = res.getWriter();
         out.print(hello.hello("Kermit"));
         out.close();
      }
      catch (Exception e)
      {
         log.error("Cannot access service", e);
      }
   }
}
