/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.jbws124;

// $Id:JBWS124TestCase.java,v 1.0, 2005-06-24 19:09:14Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/** Test that we can deploy an already modified web.xml
 *  This also allows for redeployment of an expanded *.war
 *
 * http://jira.jboss.com/jira/browse/JBWS-124
 *
 * @author Thomas.Diesler@jboss.org
 * @since 05-Mar-2005
 */
public class JBWS124TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS124TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS124TestCase.class, "ws4ee-jbws124.war, ws4ee-jbws124-client.jar");
   }

   /**
    * Test JSE endpoint
    */
   public void testEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      Hello hello = (Hello)service.getPort(Hello.class);

      String in0 = "Kermit";
      String retObj = hello.hello(in0);
      assertEquals(in0, retObj);
   }
}
