/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.header;

// $Id:HeaderEndpointTestCase.java,v 1.0, 2005-06-24 19:05:11Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;
import org.jboss.util.id.UID;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Test [ 1067384 ] ClassCastException in initServiceUse on valid WSDL
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class HeaderEndpointTestCase extends WebserviceTestBase
{
   public HeaderEndpointTestCase(String name)
   {
      super(name);
   }

   /** Send a message with IN header.
    * The service endpoint interface sees the header.
    */
   public void testSimpleHeaderEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/SimpleHeaderService");
      SimpleHeaderEndpoint port = (SimpleHeaderEndpoint)service.getPort(SimpleHeaderEndpoint.class);

      boolean result = port.doStuff("Hello World!", "kermit");
      assertTrue(result);
   }

   /** Send a message with complex IN header.
    * The service endpoint interface sees the header.
    */
   public void testBeanHeaderEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/BeanHeaderService");
      BeanHeaderEndpoint port = (BeanHeaderEndpoint)service.getPort(BeanHeaderEndpoint.class);

      SessionHeader header = new SessionHeader();
      header.setUsername("kermit");
      header.setSessionID(UID.asString());

      boolean result = port.doStuff("Hello World!", header);
      assertTrue(result);
   }

   /** Send a message with INOUT headers. The headers are processed by handlers.
    * The service endpoint interface does not see the header.
    */
   public void testImplicitHeaderEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/ImplicitHeaderService");
      ImplicitHeaderEndpoint port = (ImplicitHeaderEndpoint)service.getPort(ImplicitHeaderEndpoint.class);

      boolean result = port.doStuff("Hello World!");
      assertTrue(result);

      // Do a second call to the endpoint, this time with sessionID
      result = port.doStuff("Hello World!");
      assertTrue(result);
   }

   /** Send a message with INOUT headers.
    * The service endpoint interface sees the header.
    */
   public void testExplicitHeaderEndpoint() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/ExplicitHeaderService");
      ExplicitHeaderEndpoint port = (ExplicitHeaderEndpoint)service.getPort(ExplicitHeaderEndpoint.class);

      SessionHeader header = new SessionHeader();
      header.setUsername("kermit");
      SessionHeaderHolder holder = new SessionHeaderHolder();
      holder.value = header;

      boolean result = port.doStuff("Hello World!", holder);
      assertTrue(result);
      assertNotNull(holder.value);

      header = holder.value;
      assertEquals("kermit", header.getUsername());
      assertNotNull(header.getSessionID());

      // Do a second call to the endpoint, this time with sessionID
      result = port.doStuff("Hello World!", holder);
      assertTrue(result);
      assertNotNull(holder.value);

      header = holder.value;
      assertEquals("kermit", header.getUsername());
      assertNotNull(header.getSessionID());
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(HeaderEndpointTestCase.class, "ws4ee-header.war, ws4ee-header-client.jar");
   }
}
