/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.header;

import org.jboss.logging.Logger;
import org.jboss.util.id.UID;

import java.rmi.RemoteException;

/**
 * @author Thomas.Diesler@jboss.org
 * @since 26-Nov-2004
 */
public class ExplicitHeaderEndpointImpl implements ExplicitHeaderEndpoint
{
   // provide logging
   private final Logger log = Logger.getLogger(ExplicitHeaderEndpointImpl.class);

   public boolean doStuff(String parameter, SessionHeaderHolder headerHolder) throws RemoteException
   {
      if (parameter == null)
         throw new IllegalArgumentException("Null parameter");

      if (headerHolder == null)
         throw new IllegalArgumentException("Null headerHolder parameter");

      if (headerHolder.value == null)
         throw new IllegalArgumentException("Null headerHolder.value parameter");

      SessionHeader header = headerHolder.value;
      String username = header.getUsername();
      String sessionID = header.getSessionID();

      log.info("username: " + username);
      log.info("sessionID: " + sessionID);

      if (sessionID == null)
         header.setSessionID(UID.asString());

      return true;
   }
}
