/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.header;

import org.jboss.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import java.util.Iterator;

public class ClientHandler extends GenericHandler
{
   // provide logging
   private final Logger log = Logger.getLogger(ClientHandler.class);

   private static final String NAMESPACE_URI = ImplicitHeaderEndpoint.NAMESPACE_URI;
   private static final String LOCAL_PART = ImplicitHeaderEndpoint.LOCAL_PART;
   private static final String PREFIX = ImplicitHeaderEndpoint.PREFIX;

   private String username = "kermit";
   private String sessionID;

   public QName[] getHeaders()
   {
      QName qname = new QName(NAMESPACE_URI, LOCAL_PART);
      return new QName[]{qname};
   }

   public boolean handleRequest(MessageContext msgContext)
   {
      try
      {
         SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
         SOAPFactory factory = SOAPFactory.newInstance();

         SOAPHeader soapHeader = soapMessage.getSOAPHeader();
         Name name = factory.createName(LOCAL_PART, PREFIX, NAMESPACE_URI);
         SOAPHeaderElement headerElement = soapHeader.addHeaderElement(name);

         SOAPElement usrElement = headerElement.addChildElement("username", PREFIX, NAMESPACE_URI);
         usrElement.setValue(username);

         SOAPElement seElement = headerElement.addChildElement("sessionID", PREFIX, NAMESPACE_URI);
         seElement.setValue(sessionID);

         log.info("username: " + username);
         log.info("sessionID: " + sessionID);
         return true;
      }
      catch (SOAPException e)
      {
         throw new JAXRPCException(e.toString(), e);
      }
   }

   public boolean handleResponse(MessageContext msgContext)
   {
      try
      {
         SOAPFactory factory = SOAPFactory.newInstance();

         SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
         SOAPHeader soapHeader = soapMessage.getSOAPHeader();
         Iterator it = soapHeader.extractAllHeaderElements();

         if (it.hasNext() == false)
            throw new SOAPException("No header element");

         SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();

         Name usernameName = factory.createName("username", PREFIX, NAMESPACE_URI);
         SOAPElement usrElement = (SOAPElement)headerElement.getChildElements(usernameName).next();
         String elementValue = usrElement.getValue();
         if (username.equals(elementValue) == false)
            throw new SOAPException("Invalid username: " + elementValue);

         Name sessionIDName = factory.createName("sessionID", PREFIX, NAMESPACE_URI);
         SOAPElement seElement = (SOAPElement)headerElement.getChildElements(sessionIDName).next();
         sessionID = seElement.getValue();
         if (sessionID == null || sessionID.length() == 0)
            throw new SOAPException("Invalid sesionID: " + sessionID);

         log.info("username: " + username);
         log.info("sessionID: " + sessionID);
         return true;
      }
      catch (SOAPException e)
      {
         throw new JAXRPCException(e.toString(), e);
      }
   }
}
