/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.handlerflow;

import org.jboss.logging.Logger;

import javax.xml.rpc.handler.Handler;
import java.util.ArrayList;

/* JavaBean implementation of Hello
  */

public final class HandlerTracker
{
   private static final Logger log = Logger.getLogger(HandlerTracker.class);

   private static ArrayList protocol = new ArrayList();

   // hide constructor
   private HandlerTracker()
   {
   }

   public static String[] getProtocol()
   {
      String[] arr = new String[protocol.size()];
      protocol.toArray(arr);
      return arr;
   }

   public static void trackInit(Handler handler)
   {
      String hName = handler.getClass().getName();
      hName = hName.substring(hName.lastIndexOf(".") + 1);
      String msg = hName + " init " + trackerInfo(handler);
      protocol.add(msg);
      log.info(msg);
   }

   public static void trackDestroy(Handler handler)
   {
      String hName = handler.getClass().getName();
      hName = hName.substring(hName.lastIndexOf(".") + 1);
      String msg = hName + " destroy " + trackerInfo(handler);
      protocol.add(msg);
      log.info(msg);
   }

   public static void trackHandleRequest(Handler handler)
   {
      String hName = handler.getClass().getName();
      hName = hName.substring(hName.lastIndexOf(".") + 1);
      String msg = hName + " handleRequest " + trackerInfo(handler);
      protocol.add(msg);
      log.info(msg);
   }

   public static void trackHandleResponse(Handler handler)
   {
      String hName = handler.getClass().getName();
      hName = hName.substring(hName.lastIndexOf(".") + 1);
      String msg = hName + " handleResponse " + trackerInfo(handler);
      protocol.add(msg);
      log.info(msg);
   }

   public static void trackHandleFault(Handler handler)
   {
      String hName = handler.getClass().getName();
      hName = hName.substring(hName.lastIndexOf(".") + 1);
      String msg = hName + " handleFault " + trackerInfo(handler);
      protocol.add(msg);
      log.info(msg);
   }

   public static void trackMessage(String msg)
   {
      protocol.add(msg);
      log.info(msg);
   }

   public static void clear()
   {
      protocol.clear();
      log.info("clear [tracker=" + HandlerTracker.class.hashCode() + "]");
   }

   private static String trackerInfo(Handler handler)
   {
      String hstr = "handler=" + handler.hashCode();
      String tstr = "tracker=" + HandlerTracker.class.hashCode();
      return "[" + hstr + "," + tstr + "]";
   }
}
