/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.exception;

// $Id:ExceptionTestCase.java,v 1.0, 2005-06-24 19:04:02Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;

/**
 * Test user exception propagation.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 23-Sep-2004
 */
public class ExceptionTestCase extends WebserviceTestBase
{
   public ExceptionTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test archives */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ExceptionTestCase.class, "ws4ee-exception.jar, ws4ee-exception-client.jar");
   }

   /** Test simple exception propagation */
   public void testException() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      ExceptionService service = (ExceptionService)iniCtx.lookup("java:comp/env/service/ExceptionService");
      ExceptionServiceInterface port = service.getPort();
      try
      {
         port.throwException();
         fail("Should have failed with UserException");
      }
      catch (UserException usrex)
      {
         // do nothing
      }
      catch (Exception e)
      {
         fail("Unexpected Exception: " + e);
      }
   }

   /** Test exception with message */
   public void testExceptionWithMessage() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      ExceptionService service = (ExceptionService)iniCtx.lookup("java:comp/env/service/ExceptionService");
      ExceptionServiceInterface port = service.getPort();

      String message = "Don't worry it's just a test";
      try
      {
         port.throwExceptionWithMessage(message);
         fail("Should have failed with UserException");
      }
      catch (UserMessageException usrex)
      {
         assertEquals(message, usrex.getMessage());
      }
      catch (Exception e)
      {
         fail("Unexpected Exception: " + e);
      }
   }

   /** Test a complex user exception */
   public void testComplexUserException() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      ExceptionService service = (ExceptionService)iniCtx.lookup("java:comp/env/service/ExceptionService");
      ExceptionServiceInterface port = service.getPort();

      String message = "Don't worry it's just a test";
      try
      {
         port.throwComplexUserException(message, 200);
         fail("Should have failed with UserException");
      }
      catch (ComplexUserException usrex)
      {
         assertEquals(message, usrex.getMessage());
         assertEquals(200, usrex.getErrorCode());
      }
      catch (Exception e)
      {
         fail("Unexpected Exception: " + e);
      }
   }
}
