/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.webservice.contextroot;

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;
import org.jboss.test.webservice.admindevel.Hello;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/** A test for the examples from the JBoss Admin Devel book.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */
public class ContextRootTestCase extends WebserviceTestBase
{
   public ContextRootTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
   }

   public void testHelloString() throws Exception
   {

      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      Hello helloPort = (Hello)service.getPort(Hello.class);
      String retStr = helloPort.helloString("Kermit");
      assertEquals("Hello Kermit!", retStr);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ContextRootTestCase.class, "ws4ee-contextroot.ear");
   }
}
