/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.attachment;

// $Id:Attachment.java,v 1.0, 2005-06-24 18:46:10Z, Robert Worsnop$

import java.rmi.Remote;
import java.rmi.RemoteException;

import javax.activation.DataHandler;
import javax.xml.transform.Source;

/**
 * Service Endpoint Interface for the MIME mapping required by JAXRPC-1.1
 *
 * image/gif         java.awt.Image
 * image/jpeg        java.awt.Image
 * text/plain        java.lang.String
 * multipart/*       javax.mail.internet.MimeMultipart
 * text/xml          javax.xml.transform.Source
 * application/xml   javax.xml.transform.Source
 *
 * @author Thomas.Diesler@jboss.org
 * @since Nov 17, 2004
 */
public interface Attachment extends Remote
{
   /** Service endpoint method for image/gif */
   String sendMimeImageGIF(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for image/jpeg */
   String sendMimeImageJPEG(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for text/plain */
   String sendMimeTextPlain(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for multipart/* */
   String sendMimeMultipart(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for text/xml */
   String sendMimeTextXML(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for application/xml */
   String sendMimeApplicationXML(String message, Object mimepart) throws RemoteException;

   /** Service endpoint method for image/gif */
   Object echoMimeImageGIF(Object mimepart) throws RemoteException;

   /** Service endpoint method for image/jpeg */
   Object echoMimeImageJPEG(Object mimepart) throws RemoteException;

   /** Service endpoint method for text/plain */
   Object echoMimeTextPlain(Object mimepart) throws RemoteException;

   /** Service endpoint method for multipart/* */
   Object echoMimeMultipart(Object mimepart) throws RemoteException;

   /** Service endpoint method for text/xml */
   Object echoMimeTextXML(Object mimepart) throws RemoteException;

   /** Service endpoint method for application/xml */
   Source echoMimeApplicationXML(Source mimepart) throws RemoteException;

   DataHandler echoHandler(DataHandler mimepart) throws RemoteException;
}
