/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.admindevel;

// $Id:HelloEJBImpl.java,v 1.0, 2005-06-24 19:05:22Z, Robert Worsnop$

import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import java.rmi.RemoteException;

/**
 * The typical Hello Session Bean this time
 * as a web-service.
 */
public class HelloEJBImpl implements javax.ejb.SessionBean
{
   public String helloString(String name)
   {
      return "Hello " + name + "!";
   }

   public HelloObj helloBean(HelloObj bean)
   {
      String msg = helloString(bean.getMsg());
      HelloObj hro = new HelloObj(msg);
      return hro;
   }

   public HelloObj[] helloArray(HelloObj[] query)
   {
      HelloObj[] reply = new HelloObj[query.length];
      for (int n = 0; n < query.length; n++)
      {
         HelloObj hello = (HelloObj)query[n];
         String msg = helloString(hello.getMsg());
         HelloObj hro = new HelloObj(msg);
         reply[n] = hro;
      }
      return reply;
   }

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
   }

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
   }

   public void ejbActivate()
   {
   }

   public void ejbPassivate()
   {
   }
}
