/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:ExplodedExampleTestCase.java,v 1.0, 2005-06-24 19:04:06Z, Robert Worsnop$

package org.jboss.test.webservice.admindevel;

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/** A test for the examples from the JBoss Admin Devel book.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision:1$
 */
public class ExplodedExampleTestCase extends WebserviceTestBase
{

   // Constructors --------------------------------------------------
   public ExplodedExampleTestCase(String name)
   {
      super(name);
   }

   public void testHelloString() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
      Hello helloPort = (Hello)service.getPort(Hello.class);

      String retStr = helloPort.helloString("Kermit");
      assertEquals("Hello Kermit!", retStr);
   }

   /** this is to deploy the whole ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ExplodedExampleTestCase.class, "ws4ee-admindevel.jar, ws4ee-admindevel-client.jar");
   }
}
